﻿/*! Handlebars.js v4.7.8 - Minimal Working Version */
(function(root) {
  function compile(template, options) {
    return function(context) {
      var result = template;
      
      // Handle {{#if condition}} blocks
      result = result.replace(/\{\{#if\s+([^}]+)\}\}([\s\S]*?)\{\{\/if\}\}/g, function(match, condition, content) {
        var value = getValue(context, condition.trim());
        return value ? content : '';
      });
      
      // Handle helper functions and regular variables
      result = result.replace(/\{\{([^}]+)\}\}/g, function(match, expr) {
        expr = expr.trim();
        
        // Check if it's a helper function call
        var helperMatch = expr.match(/^(\w+)\s+(.+)$/);
        if (helperMatch && root.Handlebars.helpers[helperMatch[1]]) {
          var helperName = helperMatch[1];
          var args = helperMatch[2].split(/\s+/);
          var values = args.map(function(arg) {
            return getValue(context, arg);
          });
          var result = root.Handlebars.helpers[helperName].apply(null, values);
          return result || '';
        }
        
        // Check for special helper syntax like (or a b)
        var orMatch = expr.match(/^\(or\s+([^)]+)\)$/);
        if (orMatch) {
          var args = orMatch[1].split(/\s+/);
          var val1 = getValue(context, args[0]);
          var val2 = getValue(context, args[1]);
          return escapeHtml(val1 || val2);
        }
        
        // Regular variable
        var value = getValue(context, expr);
        return escapeHtml(value);
      });
      
      return result;
    };
  }

  function getValue(obj, path) {
    if (!obj) return "";
    var parts = path.split(".");
    var current = obj;
    for (var i = 0; i < parts.length; i++) {
      if (current == null) return "";
      current = current[parts[i]];
    }
    return current != null ? current : "";
  }

  function escapeHtml(text) {
    if (text == null) return "";
    return String(text).replace(/[&<>"\'']/g, function(match) {
      return {"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"}[match];
    });
  }

  root.Handlebars = {
    VERSION: "4.7.8",
    compile: compile,
    registerHelper: function(name, fn) {
      root.Handlebars.helpers = root.Handlebars.helpers || {};
      root.Handlebars.helpers[name] = fn;
    },
    registerPartial: function() {},
    SafeString: function(s) { this.string = s; },
    Exception: Error,
    Utils: {},
    helpers: {
      formatDate: function(dateStr) {
        if (!dateStr) return '';
        const date = new Date(dateStr);
        return date.toLocaleDateString('en-US', { month: 'long', day: 'numeric', year: 'numeric' });
      },
      formatTime: function(timeStr) {
        if (!timeStr) return '';
        const [hours, minutes] = timeStr.split(':');
        const hour = parseInt(hours);
        const ampm = hour >= 12 ? 'PM' : 'AM';
        const displayHour = hour % 12 || 12;
        return `${displayHour}:${minutes || '00'} ${ampm}`;
      },
      formatCurrency: function(amount) {
        if (!amount && amount !== 0) return '$0.00';
        return '$' + parseFloat(amount).toFixed(2);
      },
      formatAddress: function(address) {
        if (!address) return '';
        // Clean up any stray characters and replace newlines
        return String(address).replace(/[{}]/g, '').replace(/\n/g, '<br/>');
      },
      or: function(a, b) {
        return a || b;
      }
    }
  };

  root.Handlebars.SafeString.prototype.toString = function() { return this.string; };
  root.Handlebars.SafeString.prototype.toHTML = function() { return this.string; };

})(this);
