# RENAME: Invoicer --> Booker

## Date: 2026-01-30
## Purpose: Rename all references from "Invoicer" to "Booker" across client codebase
## Note: Invoicer.js is KEPT as-is (not deleted). Booker.js is a new file.

---

## REVERSAL GUIDE
To reverse ALL changes below, apply the OPPOSITE of each change listed.

---

## 1. NEW FILE CREATED

| Action | File |
|--------|------|
| CREATED | `client/js/pages/Booker.js` (copy of Invoicer.js with class renamed) |

**To reverse:** Delete `client/js/pages/Booker.js`

---

## 2. leedz_config.json

| Line | Old Value | New Value |
|------|-----------|-----------|
| 32 | `"module": "js/pages/Invoicer.js"` | `"module": "js/pages/Booker.js"` |
| 33 | `"className": "Invoicer"` | `"className": "Booker"` |

**To reverse:** Change module back to `"js/pages/Invoicer.js"` and className back to `"Invoicer"`

---

## 3. sidebar.html

| Line | Old Value | New Value |
|------|-----------|-----------|
| 148 | `<!-- INVOICER PAGE (default/existing content) -->` | `<!-- BOOKER PAGE (default/existing content) -->` |
| 185 | `</div><!-- END page-invoicer -->` | `</div><!-- END page-booker -->` |
| 549 | `<!-- INVOICER BUTTONS - Fixed position outside scrolling area, above footer -->` | `<!-- BOOKER BUTTONS - Fixed position outside scrolling area, above footer -->` |
| 550 | `<!-- Only visible when invoicer page is active -->` | `<!-- Only visible when booker page is active -->` |
| 551 | `id="invoicer-buttons"` | `id="booker-buttons"` |

**To reverse:** Change all back to `INVOICER`/`invoicer-buttons`/`page-invoicer`

---

## 4. sidebar.js

| Line | Old Value | New Value |
|------|-----------|-----------|
| 269 | `getElementById('invoicer-buttons')` | `getElementById('booker-buttons')` |
| 276 | `if (invoicerButtons)` | `if (bookerButtons)` |
| 366 | `getElementById('invoicer-buttons')` | `getElementById('booker-buttons')` |
| 374 | `if (invoicerButtons)` | `if (bookerButtons)` |
| 383 | `page.pageName === 'invoicer' && invoicerButtons` | `page.pageName === 'booker' && bookerButtons` |
| 384 | `invoicerButtons.style.display` | `bookerButtons.style.display` |
| 400 | `use invoicer-buttons wrapper` (comment) | `use booker-buttons wrapper` |
| 401 | `getElementById('invoicer-buttons')` | `getElementById('booker-buttons')` |

Variable renames in both functions:
- `const invoicerButtons` --> `const bookerButtons`

**To reverse:** Change all `booker-buttons` back to `invoicer-buttons`, `bookerButtons` to `invoicerButtons`, `'booker'` to `'invoicer'`

---

## 5. leedz_layout.css

| Line | Old Value | New Value |
|------|-----------|-----------|
| 125 | `/* Default invoicer page - dark green */` | `/* Default booker page - dark green */` |
| 126 | `.app-label.invoicer` | `.app-label.booker` |
| 148 | `/* Invoicer button wrapper - hidden by default */` | `/* Booker button wrapper - hidden by default */` |
| 149 | `#invoicer-buttons` | `#booker-buttons` |
| 150 | `/* Hidden by default - JavaScript shows when invoicer page is active */` | `/* Hidden by default - JavaScript shows when booker page is active */` |

**To reverse:** Change all `.app-label.booker` back to `.app-label.invoicer`, `#booker-buttons` to `#invoicer-buttons`

---

## 6. COMMENT-ONLY CHANGES (non-functional)

These files had comments updated from "Invoicer" to "Booker":

| File | Line(s) | Change |
|------|---------|--------|
| `client/js/state.js` | 30, 41, 176, 187 | "Invoicer" --> "Booker" in comments |
| `client/js/pages/DataPage.js` | 11 | "Invoicer" --> "Booker" in class list comment |
| `client/js/pages/Page.js` | 20 | `'invoicer'` --> `'booker'` in JSDoc example |
| `client/js/utils/Calculator.js` | 9 | "Invoicer" --> "Booker" in Used by comment |
| `client/js/utils/Page_Utils.js` | 282 | "Invoicer" --> "Booker" in comment |
| `client/js/pages/Responder.js` | 20 | "Invoicer" --> "Booker" in comment |
| `client/js/db/DB_local_prisma_sqlite.js` | 132 | "Invoicer" --> "Booker" in comment |
| `client/js/content.js` | 308 | "Invoicer" --> "Booker" in comment |
| `client/js/provider_registry.js` | 4 | "Leedz Invoicer" --> "Leedz Booker" in comment |
| `client/js/logging.js` | 6 | "Leedz Invoicer" --> "Leedz Booker" in comment |

**To reverse:** Change all "Booker" back to "Invoicer" in the listed comment lines

---

## 7. FILES NOT CHANGED (intentional)

| File | Reason |
|------|--------|
| `client/js/pages/Invoicer.js` | KEPT as original (not deleted) |
| `client/manifest.json` | "Open Leedz Invoicer" is product name |
| `client/html/index.html` | Marketing/docs page |
| Root directory `INVOICER/` | Directory name unchanged per request |
| `client/js/parser/gmail_parser*.js` | References `invoicer_config.json` file (separate concern) |
| `client/js/parser/gcal_parser.js` | References `invoicer_config.json` file (separate concern) |
